<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($subject ?? 'Notifikasi Admin') ?></title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .email-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: bold;
        }
        .email-body {
            padding: 30px;
        }
        .email-footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            font-size: 14px;
            color: #6c757d;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            margin: 10px 0;
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
        }
        .alert-info {
            background: #e7f3ff;
            border-left: 4px solid #0dcaf0;
            color: #055160;
        }
        .alert-success {
            background: #d1e7dd;
            border-left: 4px solid #198754;
            color: #0a3622;
        }
        .alert-warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            color: #664d03;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <h1><?= esc($subject ?? 'Notifikasi Admin Panel') ?></h1>
        </div>
        <div class="email-body">
            <?= $content ?? '' ?>
            
            <?php if (isset($actionUrl) && isset($actionText)): ?>
                <div style="text-align: center; margin: 30px 0;">
                    <a href="<?= esc($actionUrl) ?>" class="btn"><?= esc($actionText) ?></a>
                </div>
            <?php endif; ?>
        </div>
        <div class="email-footer">
            <p>Email ini dikirim secara otomatis dari Admin Panel</p>
            <p>Jangan balas email ini. Jika ada pertanyaan, silakan hubungi administrator.</p>
        </div>
    </div>
</body>
</html>
